<?php
// Tests how links and anchors to docs included into current work.

class UtiacPager extends UWikiPagerStub {
  function ReadPage($file, $format = null) { return $GLOBALS['tiacIncludes'][$file]; }
}

class Utiac_dynamic_Root extends UWikiBaseAction {
  function IsDynamic($format, $params) { return true; }
  function Execute($format, $params) { }
}


  $GLOBALS['tiacIncludes'] = array('doc1' => '
== doc1 title ==
((#inner)), is linked to here from doc2.
((doc2#inner link to doc2\'s anchor))
((doc2 link to doc2))
',
                                   'doc2' =>'
=== titleless ===
((#inner)), is linked to here from doc1.
((doc1#inner link to doc1\'s anchor))
((doc1 link to doc1))
');

  $src = '
{{include doc1}}
---
{{include doc2}}
---
==doc1 includer==
';    // "doc1 includer" will cause regeneration of "doc1 title".
  $doc = new UWikiDocument($src);
  $doc->settings = $settings;
  $doc->settings->pager = new UtiacPager;
  $doc->LoadMarkup('wacko');

  $doc->Parse();
  $html = $doc->ToHTML();

$expectedHTML = '
<h2>
doc1 title<a name="doc1_title" href="#doc1_title" title="#doc1_title" class="anchor">¶</a>
</h2>
<p class="default">
<a name="inner" href="#inner" title="#inner" class="anchor">¶</a>, is linked to here from doc2.
<a href="#inner" title="doc2#inner" class="round-brackets internal">link to doc2\'s anchor</a>
<a href="#doc2" title="doc2" class="round-brackets internal">link to doc2</a>
<a name="p_1-1" href="#p_1-1" title="#p_1-1" class="anchor">¶</a>
</p>
<hr class="thin" />
<a name="doc2" href="#doc2" title="#doc2" class="anchor include block-anchor">
¶
</a>
<h3>
titleless<a name="titleless" href="#titleless" title="#titleless" class="anchor">¶</a>
</h3>
<p class="default">
<a name="inner_1" href="#inner_1" title="#inner_1" class="anchor">¶</a>, is linked to here from doc1.
<a href="#inner" title="doc1#inner" class="round-brackets internal">link to doc1\'s anchor</a>
<a href="#doc1_title" title="doc1" class="round-brackets internal">link to doc1</a>
<a name="p_1.0.1-1" href="#p_1.0.1-1" title="#p_1.0.1-1" class="anchor">¶</a>
</p>
<hr class="thin" />
<h1>
doc1 includer<a name="doc1_includer" href="#doc1_includer" title="#doc1_includer" class="anchor">¶</a>
</h1>';

  TestEquality( preg_replace('/(\r?\n)+/u', "\n", trim($html)), trim($expectedHTML) );
